//Falcon-180B DATASET v1.0 Category: Geometric algorithms ; Style: dynamic
#include <stdio.h>
#include <math.h>

#define PI 3.14159265358979323846

typedef struct {
    double x, y;
} Point;

typedef struct {
    Point p1, p2;
} LineSegment;

typedef struct {
    Point center;
    double radius;
} Circle;

Point createPoint(double x, double y) {
    Point p;
    p.x = x;
    p.y = y;
    return p;
}

LineSegment createLineSegment(Point p1, Point p2) {
    LineSegment ls;
    ls.p1 = p1;
    ls.p2 = p2;
    return ls;
}

Circle createCircle(Point center, double radius) {
    Circle c;
    c.center = center;
    c.radius = radius;
    return c;
}

double distance(Point p1, Point p2) {
    double dx = p2.x - p1.x;
    double dy = p2.y - p1.y;
    return sqrt(dx * dx + dy * dy);
}

double area(Circle c) {
    return PI * c.radius * c.radius;
}

double perimeter(Circle c) {
    return 2 * PI * c.radius;
}

int main() {
    Point p1 = createPoint(0, 0);
    Point p2 = createPoint(1, 1);
    LineSegment ls = createLineSegment(p1, p2);
    Circle c = createCircle(p1, 1);

    printf("Distance between points: %.2f\n", distance(p1, p2));
    printf("Area of circle: %.2f\n", area(c));
    printf("Perimeter of circle: %.2f\n", perimeter(c));

    return 0;
}