//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_EMAILS 1000
#define MAX_EMAIL_LEN 100

typedef struct {
    char email[MAX_EMAIL_LEN];
    int subscribed;
} Email;

Email emails[MAX_EMAILS];
int num_emails = 0;

void add_email(char* email) {
    if (num_emails >= MAX_EMAILS) {
        printf("Error: Too many emails!\n");
        return;
    }
    strcpy(emails[num_emails].email, email);
    emails[num_emails].subscribed = 1;
    num_emails++;
}

void remove_email(char* email) {
    int i;
    for (i = 0; i < num_emails; i++) {
        if (strcmp(emails[i].email, email) == 0) {
            emails[i].subscribed = 0;
            break;
        }
    }
}

void send_email(char* email, char* subject, char* body) {
    int i;
    for (i = 0; i < num_emails; i++) {
        if (strcmp(emails[i].email, email) == 0 && emails[i].subscribed) {
            printf("Sending email to %s: %s\n", emails[i].email, subject);
        }
    }
}

int main() {
    add_email("john@example.com");
    add_email("jane@example.com");
    send_email("john@example.com", "Hello", "World");
    remove_email("jane@example.com");
    send_email("john@example.com", "Goodbye", "World");
    return 0;
}