//Gemma-7B DATASET v1.0 Category: Bingo Simulator ; Style: authentic
#include <stdio.h>
#include <stdlib.h>

#define MAX_BINGO_NUMS 5

typedef struct BingoCard {
    int numbers[MAX_BINGO_NUMS];
    int isWinner;
} BingoCard;

void initializeBingoCard(BingoCard *card) {
    for (int i = 0; i < MAX_BINGO_NUMS; i++) {
        card->numbers[i] = -1;
    }
    card->isWinner = 0;
}

void markBingoCard(BingoCard *card, int number) {
    for (int i = 0; i < MAX_BINGO_NUMS; i++) {
        if (card->numbers[i] == number) {
            card->numbers[i] = 0;
        }
    }
}

int checkBingoCard(BingoCard *card) {
    // Check rows
    for (int i = 0; i < MAX_BINGO_NUMS; i++) {
        if (card->numbers[i] == 0 && card->numbers[i+1] == 0 && card->numbers[i+2] == 0) {
            return 1;
        }
    }

    // Check columns
    for (int i = 0; i < MAX_BINGO_NUMS; i++) {
        if (card->numbers[i] == 0 && card->numbers[i+MAX_BINGO_NUMS] == 0 && card->numbers[i+2*MAX_BINGO_NUMS] == 0) {
            return 1;
        }
    }

    // Check diagonals
    if (card->numbers[0] == 0 && card->numbers[MAX_BINGO_NUMS] == 0 && card->numbers[2*MAX_BINGO_NUMS] == 0) {
        return 1;
    }

    // No winner
    return 0;
}

int main() {
    BingoCard card;
    initializeBingoCard(&card);

    // Mark the card
    markBingoCard(&card, 10);
    markBingoCard(&card, 12);
    markBingoCard(&card, 14);

    // Check if the card is a winner
    if (checkBingoCard(&card)) {
        printf("You are a winner!");
    } else {
        printf("Sorry, you are not a winner.");
    }

    return 0;
}