//GEMINI-pro DATASET v1.0 Category: Queue Implementation ; Style: Donald Knuth
#include <stdio.h>
#include <assert.h>

#define MAX_QUEUE_SIZE 100

typedef struct {
  int front;
  int rear;
  int size;
  int queue[MAX_QUEUE_SIZE];
} Queue;

// Initialize a queue
void init_queue(Queue *q) {
  q->front = q->rear = -1;
  q->size = 0;
}

// Check if the queue is empty
int is_queue_empty(Queue *q) {
  return q->size == 0;
}

// Check if the queue is full
int is_queue_full(Queue *q) {
  return q->size == MAX_QUEUE_SIZE;
}

// Enqueue an element
void enqueue(Queue *q, int data) {
  if (is_queue_full(q)) {
    printf("Error: Queue is full!\n");
    return;
  }
  if (q->front == -1) {
    q->front = q->rear = 0;
  } else {
    q->rear = (q->rear + 1) % MAX_QUEUE_SIZE;
  }
  q->queue[q->rear] = data;
  q->size++;
}

// Dequeue an element
int dequeue(Queue *q) {
  if (is_queue_empty(q)) {
    printf("Error: Queue is empty!\n");
    return -1;
  }
  int data = q->queue[q->front];
  if (q->front == q->rear) {
    q->front = q->rear = -1;
  } else {
    q->front = (q->front + 1) % MAX_QUEUE_SIZE;
  }
  q->size--;
  return data;
}

// Helper function to print the queue
void print_queue(Queue *q) {
  if (is_queue_empty(q)) {
    printf("Queue is empty.\n");
    return;
  }
  printf("Queue: ");
  for (int i = q->front; i != q->rear; i = (i + 1) % MAX_QUEUE_SIZE) {
    printf("%d ", q->queue[i]);
  }
  printf("%d\n", q->queue[q->rear]);
}

int main() {
  Queue q;
  init_queue(&q);

  // Enqueue some elements
  enqueue(&q, 1);
  enqueue(&q, 2);
  enqueue(&q, 3);
  enqueue(&q, 4);
  enqueue(&q, 5);

  // Print the queue
  print_queue(&q);

  // Dequeue some elements
  int data = dequeue(&q);
  printf("Dequeued element: %d\n", data);
  data = dequeue(&q);
  printf("Dequeued element: %d\n", data);

  // Print the queue
  print_queue(&q);

  return 0;
}