//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LIGHTS 10
#define MAX_LIGHT_NAME_LEN 20

typedef struct {
    char name[MAX_LIGHT_NAME_LEN];
    int brightness;
    int is_on;
} Light;

Light lights[MAX_LIGHTS];
int num_lights;

void add_light(char *name) {
    if (num_lights >= MAX_LIGHTS) {
        printf("Error: Maximum number of lights reached.\n");
        return;
    }

    strcpy(lights[num_lights].name, name);
    lights[num_lights].brightness = 0;
    lights[num_lights].is_on = 0;

    num_lights++;
}

void remove_light(int index) {
    if (index < 0 || index >= num_lights) {
        printf("Error: Invalid light index.\n");
        return;
    }

    num_lights--;

    if (index < num_lights) {
        memmove(lights + index, lights + index + 1, sizeof(Light) * (num_lights - index));
    }
}

void set_brightness(int index, int brightness) {
    if (index < 0 || index >= num_lights) {
        printf("Error: Invalid light index.\n");
        return;
    }

    lights[index].brightness = brightness;
}

void toggle_light(int index) {
    if (index < 0 || index >= num_lights) {
        printf("Error: Invalid light index.\n");
        return;
    }

    lights[index].is_on =!lights[index].is_on;
}

void print_lights() {
    printf("Lights:\n");
    for (int i = 0; i < num_lights; i++) {
        printf("%s: %d (on: %s)\n", lights[i].name, lights[i].brightness, lights[i].is_on? "yes" : "no");
    }
}

int main() {
    add_light("Living Room Lamp");
    add_light("Bedroom Lamp");
    add_light("Kitchen Light");

    set_brightness(0, 50);
    set_brightness(1, 75);
    set_brightness(2, 100);

    toggle_light(0);
    toggle_light(1);
    toggle_light(2);

    print_lights();

    remove_light(1);

    print_lights();

    return 0;
}