//Falcon-180B DATASET v1.0 Category: Rogue-like Game with Procedural Generation ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_ROOMS 20
#define MAX_ROOM_SIZE 10
#define MAX_ENEMIES 10
#define MAX_ITEMS 10

typedef struct {
    int x, y;
} Point;

typedef struct {
    Point pos;
    char symbol;
} Room;

typedef struct {
    Point pos;
    char symbol;
    int health;
} Enemy;

typedef struct {
    Point pos;
    char symbol;
} Item;

void generate_room(Room* room) {
    room->pos.x = rand() % MAX_ROOM_SIZE;
    room->pos.y = rand() % MAX_ROOM_SIZE;
    room->symbol = rand() % 3 + 'A';
}

void generate_enemy(Enemy* enemy) {
    enemy->pos.x = rand() % MAX_ROOM_SIZE;
    enemy->pos.y = rand() % MAX_ROOM_SIZE;
    enemy->symbol = rand() % 3 + 'E';
    enemy->health = rand() % 10 + 1;
}

void generate_item(Item* item) {
    item->pos.x = rand() % MAX_ROOM_SIZE;
    item->pos.y = rand() % MAX_ROOM_SIZE;
    item->symbol = rand() % 3 + 'I';
}

void generate_dungeon(Room rooms[MAX_ROOMS], Enemy enemies[MAX_ENEMIES], Item items[MAX_ITEMS]) {
    srand(time(NULL));

    for (int i = 0; i < MAX_ROOMS; i++) {
        generate_room(&rooms[i]);
    }

    for (int i = 0; i < MAX_ENEMIES; i++) {
        generate_enemy(&enemies[i]);
    }

    for (int i = 0; i < MAX_ITEMS; i++) {
        generate_item(&items[i]);
    }
}

int main() {
    Room rooms[MAX_ROOMS];
    Enemy enemies[MAX_ENEMIES];
    Item items[MAX_ITEMS];

    generate_dungeon(rooms, enemies, items);

    return 0;
}