//GEMINI-pro DATASET v1.0 Category: Medical Store Management System ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of customers and drugs
#define MAX_CUSTOMERS 100
#define MAX_DRUGS 100

// Define the structure of a customer
typedef struct customer {
    int id;
    char name[50];
    char address[100];
    char phone[20];
} customer;

// Define the structure of a drug
typedef struct drug {
    int id;
    char name[50];
    char manufacturer[50];
    float price;
    int quantity;
} drug;

// Initialize the arrays of customers and drugs
customer customers[MAX_CUSTOMERS];
drug drugs[MAX_DRUGS];

// Initialize the number of customers and drugs
int num_customers = 0;
int num_drugs = 0;

// Function to add a new customer
void add_customer(customer c) {
    // Check if the customer array is full
    if (num_customers >= MAX_CUSTOMERS) {
        printf("The customer array is full.\n");
        return;
    }

    // Add the customer to the array
    customers[num_customers] = c;
    num_customers++;
}

// Function to add a new drug
void add_drug(drug d) {
    // Check if the drug array is full
    if (num_drugs >= MAX_DRUGS) {
        printf("The drug array is full.\n");
        return;
    }

    // Add the drug to the array
    drugs[num_drugs] = d;
    num_drugs++;
}

// Function to search for a customer by ID
customer *search_customer_by_id(int id) {
    // Linear search for the customer
    for (int i = 0; i < num_customers; i++) {
        if (customers[i].id == id) {
            return &customers[i];
        }
    }

    // Return NULL if the customer is not found
    return NULL;
}

// Function to search for a drug by ID
drug *search_drug_by_id(int id) {
    // Linear search for the drug
    for (int i = 0; i < num_drugs; i++) {
        if (drugs[i].id == id) {
            return &drugs[i];
        }
    }

    // Return NULL if the drug is not found
    return NULL;
}

// Function to print the details of a customer
void print_customer(customer c) {
    printf("Customer ID: %d\n", c.id);
    printf("Customer Name: %s\n", c.name);
    printf("Customer Address: %s\n", c.address);
    printf("Customer Phone: %s\n", c.phone);
}

// Function to print the details of a drug
void print_drug(drug d) {
    printf("Drug ID: %d\n", d.id);
    printf("Drug Name: %s\n", d.name);
    printf("Drug Manufacturer: %s\n", d.manufacturer);
    printf("Drug Price: %f\n", d.price);
    printf("Drug Quantity: %d\n", d.quantity);
}

// Main function
int main() {
    // Add some sample customers and drugs
    customer c1 = {1, "Sherlock Holmes", "221B Baker Street, London", "0123456789"};
    add_customer(c1);
    customer c2 = {2, "Dr. Watson", "221B Baker Street, London", "0123456789"};
    add_customer(c2);
    drug d1 = {1, "Aspirin", "Bayer", 10.0, 100};
    add_drug(d1);
    drug d2 = {2, "Ibuprofen", "Advil", 15.0, 50};
    add_drug(d2);

    // Search for a customer by ID
    customer *cust = search_customer_by_id(1);
    if (cust != NULL) {
        printf("Customer found:\n");
        print_customer(*cust);
    } else {
        printf("Customer not found.\n");
    }

    // Search for a drug by ID
    drug *drug = search_drug_by_id(1);
    if (drug != NULL) {
        printf("Drug found:\n");
        print_drug(*drug);
    } else {
        printf("Drug not found.\n");
    }

    return 0;
}