//Code Llama-13B DATASET v1.0 Category: Rogue-like Game with Procedural Generation ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAP_WIDTH 10
#define MAP_HEIGHT 10
#define MAX_ROOMS 10
#define ROOM_SIZE 5
#define MAX_ENEMIES 5
#define MAX_ITEMS 5

typedef struct {
    int x;
    int y;
} Point;

typedef struct {
    char name[10];
    int hp;
    int attack;
    int defense;
} Enemy;

typedef struct {
    char name[10];
    int value;
} Item;

typedef struct {
    Point start;
    Point end;
} Room;

void generate_map(Room rooms[MAX_ROOMS], Point player_start) {
    srand(time(NULL));

    for (int i = 0; i < MAX_ROOMS; i++) {
        rooms[i].start.x = rand() % MAP_WIDTH;
        rooms[i].start.y = rand() % MAP_HEIGHT;
        rooms[i].end.x = rooms[i].start.x + ROOM_SIZE;
        rooms[i].end.y = rooms[i].start.y + ROOM_SIZE;
    }

    player_start.x = rand() % MAP_WIDTH;
    player_start.y = rand() % MAP_HEIGHT;
}

void generate_enemies(Enemy enemies[MAX_ENEMIES]) {
    srand(time(NULL));

    for (int i = 0; i < MAX_ENEMIES; i++) {
        enemies[i].name[0] = 'A' + rand() % 26;
        enemies[i].hp = rand() % 10 + 1;
        enemies[i].attack = rand() % 10 + 1;
        enemies[i].defense = rand() % 10 + 1;
    }
}

void generate_items(Item items[MAX_ITEMS]) {
    srand(time(NULL));

    for (int i = 0; i < MAX_ITEMS; i++) {
        items[i].name[0] = 'A' + rand() % 26;
        items[i].value = rand() % 10 + 1;
    }
}

void print_map(Room rooms[MAX_ROOMS], Enemy enemies[MAX_ENEMIES], Item items[MAX_ITEMS], Point player_start) {
    for (int i = 0; i < MAX_ROOMS; i++) {
        printf("Room %d: %d, %d - %d, %d\n", i, rooms[i].start.x, rooms[i].start.y, rooms[i].end.x, rooms[i].end.y);
    }

    for (int i = 0; i < MAX_ENEMIES; i++) {
        printf("Enemy %d: %s - HP: %d - Attack: %d - Defense: %d\n", i, enemies[i].name, enemies[i].hp, enemies[i].attack, enemies[i].defense);
    }

    for (int i = 0; i < MAX_ITEMS; i++) {
        printf("Item %d: %s - Value: %d\n", i, items[i].name, items[i].value);
    }

    printf("Player Start: %d, %d\n", player_start.x, player_start.y);
}

int main() {
    Room rooms[MAX_ROOMS];
    Enemy enemies[MAX_ENEMIES];
    Item items[MAX_ITEMS];
    Point player_start;

    generate_map(rooms, player_start);
    generate_enemies(enemies);
    generate_items(items);

    print_map(rooms, enemies, items, player_start);

    return 0;
}