//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: funny
#include <stdio.h>
#include <stdlib.h>

int main()
{
    // Let's imagine we have a group of clowns
    int clowns[5] = {1, 2, 3, 4, 5};

    // Each clown has a special trick: juggling, balancing, unicycling, etc.
    int tricks[5] = {0b1000, 0b0100, 0b0010, 0b0001, 0b0000};

    // Now, let's say we want to select a clown that can do both juggling and balancing
    int jugglingMask = 0b1000;
    int balancingMask = 0b0100;

    // We perform a bitwise AND operation to check if the clown has both tricks
    for (int i = 0; i < 5; i++)
    {
        if ((tricks[i] & jugglingMask) && (tricks[i] & balancingMask))
        {
            printf("Clown %d: The juggling balancing act!\n", clowns[i]);
        }
    }

    // Now, let's say we want to remove the "unicycling" trick from the "balancing clown"
    int unicyclingMask = 0b0010;
    balancingMask &= ~unicyclingMask;

    printf("After removing the unicycling trick:\n");
    for (int i = 0; i < 5; i++)
    {
        if ((tricks[i] & jugglingMask) && (tricks[i] & balancingMask))
        {
            printf("Clown %d: The new juggling balancing act!\n", clowns[i]);
        }
    }

    // Oh no, the clowns got into a fight and some lost their juggling balls!
    int lostBallsMask = 0b0100;
    jugglingMask &= ~lostBallsMask;

    printf("After the fight:\n");
    for (int i = 0; i < 5; i++)
    {
        if ((tricks[i] & jugglingMask) && (tricks[i] & balancingMask))
        {
            printf("Clown %d: Now they just balance, no juggling!\n", clowns[i]);
        }
    }

    // Luckily, the show must go on! Let's check if any clown can do both balancing and unicycling now
    unicyclingMask = 0b0010;

    printf("After the juggling balls were lost:\n");
    for (int i = 0; i < 5; i++)
    {
        if ((tricks[i] & balancingMask) && (tricks[i] & unicyclingMask))
        {
            printf("Clown %d: Balancing on a unicycle, the new star of the show!\n", clowns[i]);
        }
    }

    printf("And so the circus continues, filled with laughter and a few unexpected tricks!\n");

    return 0;
}