//GPT-4o-mini DATASET v1.0 Category: Traffic Light Controller ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define RED_TIME 10
#define YELLOW_TIME 2
#define GREEN_TIME 10

typedef enum {
    RED,
    YELLOW,
    GREEN
} TrafficLightState;

void displayLight(TrafficLightState state) {
    switch (state) {
        case RED:
            printf("Traffic Light: RED\n");
            break;
        case YELLOW:
            printf("Traffic Light: YELLOW\n");
            break;
        case GREEN:
            printf("Traffic Light: GREEN\n");
            break;
    }
}

void changeTrafficLight(TrafficLightState *state) {
    switch (*state) {
        case RED:
            *state = GREEN;
            break;
        case GREEN:
            *state = YELLOW;
            break;
        case YELLOW:
            *state = RED;
            break;
    }
}

void runTrafficLightController() {
    TrafficLightState state = RED;
    int runTime = 0;  // Track total runtime

    while (runTime < 60) { // Run the simulation for 60 seconds
        displayLight(state);
        switch (state) {
            case RED:
                sleep(RED_TIME);
                runTime += RED_TIME;
                break;
            case YELLOW:
                sleep(YELLOW_TIME);
                runTime += YELLOW_TIME;
                break;
            case GREEN:
                sleep(GREEN_TIME);
                runTime += GREEN_TIME;
                break;
        }
        changeTrafficLight(&state);
    }
    
    printf("Traffic Light Controller has finished running.\n");
}

int main() {
    printf("Traffic Light Controller Simulation Started.\n");
    runTrafficLightController();
    return 0;
}