//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: detailed
#include <stdio.h>
#include <stdlib.h>

// Data structure to store an item
typedef struct Item {
    int value;
    int weight;
} Item;

// Comparison function for sorting items by value-to-weight ratio
int compare_items(const void *a, const void *b) {
    Item *item1 = (Item *)a;
    Item *item2 = (Item *)b;
    double ratio1 = (double)item1->value / item1->weight;
    double ratio2 = (double)item2->value / item2->weight;
    if (ratio1 > ratio2) {
        return -1;
    } else if (ratio1 < ratio2) {
        return 1;
    } else {
        return 0;
    }
}

// Greedy algorithm for fractional knapsack problem
double fractional_knapsack(Item *items, int num_items, int capacity) {
    // Sort items by value-to-weight ratio in descending order
    qsort(items, num_items, sizeof(Item), compare_items);

    // Initialize total value and current weight
    double total_value = 0.0;
    int current_weight = 0;

    // Iterate over items and add them to the knapsack until capacity is reached
    for (int i = 0; i < num_items; i++) {
        if (current_weight + items[i].weight <= capacity) {
            // Add the entire item to the knapsack
            total_value += items[i].value;
            current_weight += items[i].weight;
        } else {
            // Add a fraction of the item to the knapsack
            double fraction = (double)(capacity - current_weight) / items[i].weight;
            total_value += fraction * items[i].value;
            current_weight += fraction * items[i].weight;
            break;
        }
    }

    return total_value;
}

int main() {
    // Initialize items
    Item items[] = {
        {60, 10},
        {100, 20},
        {120, 30},
    };
    int num_items = sizeof(items) / sizeof(Item);

    // Initialize knapsack capacity
    int capacity = 50;

    // Solve the fractional knapsack problem
    double total_value = fractional_knapsack(items, num_items, capacity);

    // Print the total value of items in the knapsack
    printf("Total value of items in the knapsack: %.2f\n", total_value);

    return 0;
}