//GPT-4o-mini DATASET v1.0 Category: System boot optimizer ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

void summonKnight(char *knightName) {
    printf("The noble knight '%s' is summoned to optimize the kingdom's boot time!\n", knightName);
}

void prepareSteed(char *steedName) {
    printf("The mighty steed '%s' is being prepared for a gallant ride!\n", steedName);
}

void gatherResources() {
    printf("Gathering the resources from the four corners of the kingdom...\n");
    printf("  - Grains of data\n");
    printf("  - Elixirs of speed\n");
    printf("  - Shields of efficiency\n");
}

void optimizeBoot(int *bootTime) {
    printf("The knight swings his sword, optimizing the boot time...\n");
    srand(time(0)); 
    int reduction = rand() % 20; // Random reduction percentage
    *bootTime -= *bootTime * reduction / 100;
    printf("The boot time has been reduced by %d%%!\n", reduction);
}

void displayBootTime(int bootTime) {
    printf("The current boot time of the kingdom is: %d seconds\n", bootTime);
}

void offerFeast() {
    printf("The village gathers to offer a feast to celebrate the optimization!\n");
    printf("  Roasted meats and fine wines are served to the brave knights!\n");
}

int main() {
    char knightName[] = "Sir Optimize-a-lot";
    char steedName[] = "Thunderbolt";
    int bootTime = 120; // Boot time in seconds
    
    printf("A long time ago in a kingdom of bits and bytes...\n");
    printf("The kingdom suffers under the weight of slow boot times.\n");
    
    summonKnight(knightName);
    prepareSteed(steedName);
    gatherResources();
    displayBootTime(bootTime);
    
    printf("Now the knight embarks upon his grand quest!\n");
    
    optimizeBoot(&bootTime);
    displayBootTime(bootTime);
    
    printf("With the optimization complete, let us gather for a merry celebration!\n");
    offerFeast();
    
    printf("The kingdom is safe once again, and the boot times are swift!\n");
    
    return 0;
}