//Falcon2-11B DATASET v1.0 Category: Hotel Management System ; Style: systematic
#include <stdio.h>
#include <stdlib.h>

#define MAX_ROOMS 10
#define MAX_NIGHTS 30

typedef struct {
    int room_num;
    int avail_nights;
    float rate;
} Room;

int check_in(Room rooms[], int num_rooms, int room_num) {
    if (room_num < 0 || room_num >= num_rooms) {
        printf("Invalid room number.\n");
        return 0;
    }

    rooms[room_num].avail_nights -= 1;
    return 1;
}

int check_out(Room rooms[], int num_rooms, int room_num) {
    if (room_num < 0 || room_num >= num_rooms) {
        printf("Invalid room number.\n");
        return 0;
    }

    rooms[room_num].avail_nights += 1;
    return 1;
}

int update_availability(Room rooms[], int num_rooms, int room_num, int avail_nights) {
    if (room_num < 0 || room_num >= num_rooms) {
        printf("Invalid room number.\n");
        return 0;
    }

    rooms[room_num].avail_nights = avail_nights;
    return 1;
}

float calculate_rate(Room rooms[], int num_rooms, int room_num, int num_nights) {
    if (room_num < 0 || room_num >= num_rooms) {
        printf("Invalid room number.\n");
        return 0.0;
    }

    if (num_nights < 0 || num_nights > MAX_NIGHTS) {
        printf("Invalid number of nights.\n");
        return 0.0;
    }

    float rate = 0.0;

    if (rooms[room_num].avail_nights >= num_nights) {
        rate = (float)rooms[room_num].rate * num_nights;
    } else {
        rate = rooms[room_num].rate * MAX_NIGHTS;
    }

    return rate;
}

int main() {
    Room rooms[MAX_ROOMS];

    int num_rooms = 3;

    int num_nights = 7;

    int room_num = 1;

    for (int i = 0; i < num_rooms; i++) {
        rooms[i].room_num = i;
        rooms[i].avail_nights = 30;
        rooms[i].rate = 100.0;
    }

    printf("Room %d checked in for %d nights.\n", room_num, num_nights);
    check_in(rooms, num_rooms, room_num);

    printf("Room %d checked out.\n", room_num);
    check_out(rooms, num_rooms, room_num);

    printf("Room %d is available for %d nights.\n", room_num, rooms[room_num].avail_nights);
    update_availability(rooms, num_rooms, room_num, 30);

    printf("The rate for room %d for %d nights is $%.2f.\n", room_num, num_nights, calculate_rate(rooms, num_rooms, room_num, num_nights));

    return 0;
}