//GPT-4o-mini DATASET v1.0 Category: Pathfinding algorithms ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <limits.h>

#define ROW 5
#define COL 5

// Function to print the path found
void printPath(int path[][COL]) {
    printf("Path taken:\n");
    for (int i = 0; i < ROW; i++) {
        for (int j = 0; j < COL; j++) {
            if (path[i][j] == 1) {
                printf(" * ");
            } else {
                printf(" . ");
            }
        }
        printf("\n");
    }
}

// Function declarations
bool isSafe(int maze[ROW][COL], int x, int y);
bool findPath(int maze[ROW][COL], int x, int y, int path[][COL]);

// Function to check if the move is safe
bool isSafe(int maze[ROW][COL], int x, int y) {
    return (x >= 0 && x < ROW && y >= 0 && y < COL && maze[x][y] == 1);
}

// Recursive function to solve the maze using backtracking
bool findPath(int maze[ROW][COL], int x, int y, int path[][COL]) {
    // If reached the bottom right corner, return true
    if (x == ROW - 1 && y == COL - 1) {
        path[x][y] = 1; // Mark the path
        return true;
    }

    // Check if this move is valid
    if (isSafe(maze, x, y)) {
        // Mark x, y as part of the solution path
        path[x][y] = 1;

        // Move in the right direction
        if (findPath(maze, x + 1, y, path)) {
            return true;
        }

        // If moving in the right direction doesn't give a solution then
        // move down in the maze
        if (findPath(maze, x, y + 1, path)) {
            return true;
        }

        // Backtrack: unmark x, y as part of the solution path
        path[x][y] = 0;
        return false;
    }

    return false;
}

int main() {
    int maze[ROW][COL] = {
        {1, 0, 0, 0, 0},
        {1, 1, 0, 1, 0},
        {0, 1, 0, 0, 0},
        {0, 1, 1, 1, 1},
        {0, 0, 0, 0, 1}
    };

    int path[ROW][COL] = {0}; // A 2D array to keep track of the path taken

    if (!findPath(maze, 0, 0, path)) {
        printf("No path found!\n");
    } else {
        printPath(path);
    }

    return 0;
}