//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: visionary
#include <stdio.h>
#include <stdlib.h>

#define MAX 10

// Define the maze
int maze[MAX][MAX] = {
    { 0, 0, 1, 1, 0, 0, 0, 1, 0, 0 },
    { 0, 0, 1, 0, 0, 1, 0, 0, 0, 0 },
    { 1, 1, 1, 0, 1, 1, 1, 1, 1, 0 },
    { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 },
    { 0, 1, 1, 1, 1, 1, 0, 1, 1, 1 },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 1, 1, 1, 1, 1, 0, 1, 1, 1 },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
};

// Position struct to keep track of cell coordinates
typedef struct {
    int x;
    int y;
} Position;

// Function to check if the position is valid and open
int isValid(Position pos) {
    return (pos.x >= 0 && pos.x < MAX && pos.y >= 0 && pos.y < MAX && maze[pos.x][pos.y] == 0);
}

// Recursive function to find the path
int findPath(Position start, Position end, Position* path, int step) {
    // If the current position is the endpoint, return success
    if (start.x == end.x && start.y == end.y) {
        path[step] = start;  // Save the final position
        return 1;
    }
    
    // Check if the move is valid
    if (isValid(start)) {
        // Mark the cell as visited
        maze[start.x][start.y] = 2; // 2 represents visited
        
        // Save the current position in the path
        path[step] = start;
        
        // Move in different directions: down, right, up, left
        Position nextMove[4] = {
            {start.x + 1, start.y}, // Down
            {start.x, start.y + 1}, // Right
            {start.x - 1, start.y}, // Up
            {start.x, start.y - 1}  // Left
        };
        
        // Try each direction
        for (int i = 0; i < 4; i++) {
            if (findPath(nextMove[i], end, path, step + 1)) {
                return 1; // If path found in this direction
            }
        }
        
        // Backtracking: unmark the cell
        maze[start.x][start.y] = 0; // Reset to unvisited 
    }
    
    return 0; // No path found
}

// Function to print the maze path
void printPath(Position* path, int steps) {
    printf("Path to the destination:\n");
    for (int i = 0; i <= steps; i++) {
        printf("(%d, %d) ", path[i].x, path[i].y);
    }
    printf("\n");
}

int main() {
    Position start = {0, 0}; // Starting position
    Position end = {9, 9};   // Ending position
    Position path[MAX * MAX]; // Storage for the path
    int steps;

    // Initiate the maze route finding
    if (findPath(start, end, path, 0)) {
        // Successfully found a path
        printPath(path, steps);
    } else {
        printf("No path found from (%d, %d) to (%d, %d)\n", start.x, start.y, end.x, end.y);
    }

    return 0;
}