//MISTRAL-7B DATASET v1.0 Category: Building a HTTP Client ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

typedef struct {
    CURL *handle;
    CURLcode last_response;
} http_client;

void init_http_client(http_client *client) {
    client->handle = curl_easy_init();
    client->last_response = CURLE_OK;
}

void cleanup_http_client(http_client *client) {
    curl_easy_cleanup(client->handle);
}

size_t write_callback(void *ptr, size_t size, size_t nmemb, void *stream) {
    size_t written = fwrite(ptr, size, nmemb, (FILE *) stream);
    return written;
}

int main() {
    const char *url = "https://example.com";
    http_client client;
    CURLcode res;
    FILE *output_file;

    init_http_client(&client);

    output_file = fopen("output.txt", "wb");

    res = curl_easy_setopt(client.handle, CURLOPT_URL, url);
    if (res != CURLE_OK) {
        fprintf(stderr, "Failed to set URL: %s\n", curl_easy_strerror(res));
        goto cleanup;
    }

    res = curl_easy_setopt(client.handle, CURLOPT_WRITEFUNCTION, write_callback);
    res = curl_easy_setopt(client.handle, CURLOPT_WRITEDATA, output_file);

    res = curl_easy_perform(client.handle);
    if (res != CURLE_OK) {
        fprintf(stderr, "HTTP request failed: %s\n", curl_easy_strerror(res));
        goto cleanup;
    }

    client.last_response = res;

cleanup:
    curl_easy_cleanup(client.handle);
    fclose(output_file);

    printf("HTTP status code: %d\n", client.last_response);

    return EXIT_SUCCESS;
}