//Code Llama-13B DATASET v1.0 Category: Bingo Simulator ; Style: rigorous
/*
 * Bingo Simulator
 *
 * This program simulates a bingo game with 5 columns and 10 numbers per column.
 *
 * Usage:
 * 1. Run the program
 * 2. Enter a number between 1 and 50 to place a mark on the board
 * 3. If the number is not on the board, the program will ask you to enter another number
 * 4. If the number is on the board, the program will display a message indicating the number and the column it is in
 * 5. If all numbers in a column are marked, the program will display a message indicating a Bingo
 * 6. The program will then ask you to start a new game or exit
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_COLUMNS 5
#define NUM_NUMBERS_PER_COLUMN 10

// Function to generate a random number between 1 and 50
int get_random_number() {
    return (rand() % 50) + 1;
}

// Function to check if a number is on the board
int is_number_on_board(int number, int board[NUM_COLUMNS][NUM_NUMBERS_PER_COLUMN]) {
    for (int i = 0; i < NUM_COLUMNS; i++) {
        for (int j = 0; j < NUM_NUMBERS_PER_COLUMN; j++) {
            if (board[i][j] == number) {
                return 1;
            }
        }
    }
    return 0;
}

// Function to check if a column has been marked
int is_column_marked(int column, int board[NUM_COLUMNS][NUM_NUMBERS_PER_COLUMN]) {
    for (int i = 0; i < NUM_NUMBERS_PER_COLUMN; i++) {
        if (board[column][i] == 0) {
            return 0;
        }
    }
    return 1;
}

// Function to display the board
void display_board(int board[NUM_COLUMNS][NUM_NUMBERS_PER_COLUMN]) {
    for (int i = 0; i < NUM_COLUMNS; i++) {
        for (int j = 0; j < NUM_NUMBERS_PER_COLUMN; j++) {
            printf("%d ", board[i][j]);
        }
        printf("\n");
    }
}

int main() {
    // Initialize the board
    int board[NUM_COLUMNS][NUM_NUMBERS_PER_COLUMN] = {0};

    // Generate a random number
    int number = get_random_number();

    // Check if the number is on the board
    if (is_number_on_board(number, board) == 0) {
        // If the number is not on the board, display an error message
        printf("Error: Number not on board\n");
        return 1;
    }

    // Mark the number on the board
    board[number - 1][number - 1] = 0;

    // Check if a column has been marked
    for (int i = 0; i < NUM_COLUMNS; i++) {
        if (is_column_marked(i, board) == 1) {
            // If a column has been marked, display a message indicating Bingo
            printf("Bingo! Column %d marked\n", i + 1);
            return 0;
        }
    }

    // Display the board
    display_board(board);

    // Ask the user to start a new game or exit
    char choice;
    printf("Do you want to start a new game (Y/N)? ");
    scanf("%c", &choice);

    if (choice == 'Y') {
        // If the user wants to start a new game, clear the board and generate a new random number
        for (int i = 0; i < NUM_COLUMNS; i++) {
            for (int j = 0; j < NUM_NUMBERS_PER_COLUMN; j++) {
                board[i][j] = 0;
            }
        }
        number = get_random_number();
        board[number - 1][number - 1] = 0;
    } else {
        // If the user wants to exit, exit the program
        printf("Exiting program...\n");
        return 0;
    }

    return 0;
}