//Falcon2-11B DATASET v1.0 Category: Simple Web Server ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    // Create a socket
    int sockfd;
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }
    
    // Prepare the socket for use
    struct sockaddr_in servaddr;
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_addr.s_addr = INADDR_ANY;
    servaddr.sin_port = htons(8080);
    if (bind(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }
    
    // Start listening for connections
    if (listen(sockfd, 5) < 0) {
        perror("listen failed");
        exit(EXIT_FAILURE);
    }
    
    // Accept the incoming connection
    int connfd;
    if ((connfd = accept(sockfd, NULL, NULL)) < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }
    
    // Receive the data from the client
    char buffer[1024];
    memset(buffer, 0, sizeof(buffer));
    if (recv(connfd, buffer, sizeof(buffer), 0) < 0) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }
    
    // Send a response to the client
    send(connfd, buffer, strlen(buffer), 0);
    
    // Close the connection
    close(connfd);
    close(sockfd);
    
    return 0;
}