//LLAMA2-13B DATASET v1.0 Category: Email Client ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 25
#define MAX_SIZE 1024

struct email {
    char *from;
    char *to;
    char *subject;
    char *message;
};

void connect_to_server(int sock);
void send_email(int sock, struct email *email);
void receive_email(int sock, struct email *email);
void close_connection(int sock);

int main() {
    int sock;
    struct email email;

    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket() failed");
        exit(1);
    }

    email.from = "user@example.com";
    email.to = "recipient@example.com";
    email.subject = "Test email";
    email.message = "This is a test email.";

    connect_to_server(sock);
    send_email(sock, &email);
    receive_email(sock, &email);
    close_connection(sock);

    return 0;
}

void connect_to_server(int sock) {
    struct sockaddr_in server_addr;
    char *host = "smtp.example.com";
    int port = PORT;

    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(port);
    inet_pton(AF_INET, host, &server_addr.sin_addr);

    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect() failed");
        exit(1);
    }
}

void send_email(int sock, struct email *email) {
    char *message = email->message;
    int len = strlen(message);

    if (send(sock, message, len, 0) < len) {
        perror("send() failed");
        exit(1);
    }
}

void receive_email(int sock, struct email *email) {
    char buffer[MAX_SIZE];
    int len = recv(sock, buffer, MAX_SIZE, 0);

    if (len < 0) {
        perror("recv() failed");
        exit(1);
    }

    email->message = buffer;
}

void close_connection(int sock) {
    close(sock);
}