//Gemma-7B DATASET v1.0 Category: Hotel Management System ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>

// Define a structure for a hotel room
typedef struct Room {
    int room_number;
    char status;
    float price;
} Room;

// Define a function to check if a room is available
int is_room_available(Room *room) {
    return room->status == 'A';
}

// Define a function to book a room
void book_room(Room *room) {
    room->status = 'B';
}

// Define a function to calculate the total cost of a stay
float calculate_cost(Room *room, int num_days) {
    return room->price * num_days;
}

// Main function
int main() {
    // Create an array of rooms
    Room rooms[10];

    // Initialize the rooms
    for (int i = 0; i < 10; i++) {
        rooms[i].room_number = i + 1;
        rooms[i].status = 'A';
        rooms[i].price = 100 + i * 10;
    }

    // Check if room 5 is available
    if (is_room_available(&rooms[4])) {
        // Book room 5
        book_room(&rooms[4]);

        // Calculate the total cost of a stay for 3 days
        float total_cost = calculate_cost(&rooms[4], 3);

        // Print the total cost
        printf("Total cost: $%.2f", total_cost);
    } else {
        // Print an error message
        printf("Room not available");
    }

    return 0;
}