//GEMINI-pro DATASET v1.0 Category: Drone Remote Control ; Style: lively
#include <stdio.h>
#include <stdlib.h>

// Function prototypes
void takeoff(void);
void land(void);
void forward(int distance);
void backward(int distance);
void left(int angle);
void right(int angle);
void up(int altitude);
void down(int altitude);
void hover(int duration);
void flip(int direction);

// Main function
int main(void) {
  // Take off
  takeoff();

  // Fly forward
  forward(100);

  // Turn left
  left(90);

  // Fly forward
  forward(100);

  // Turn right
  right(90);

  // Fly backward
  backward(100);

  // Turn left
  left(90);

  // Fly backward
  backward(100);

  // Turn right
  right(90);

  // Land
  land();

  return 0;
}

// Function definitions

void takeoff(void) {
  printf("Taking off...\n");
}

void land(void) {
  printf("Landing...\n");
}

void forward(int distance) {
  printf("Flying forward %d meters...\n", distance);
}

void backward(int distance) {
  printf("Flying backward %d meters...\n", distance);
}

void left(int angle) {
  printf("Turning left %d degrees...\n", angle);
}

void right(int angle) {
  printf("Turning right %d degrees...\n", angle);
}

void up(int altitude) {
  printf("Ascending to %d meters...\n", altitude);
}

void down(int altitude) {
  printf("Descending to %d meters...\n", altitude);
}

void hover(int duration) {
  printf("Hovering for %d seconds...\n", duration);
}

void flip(int direction) {
  printf("Flipping %s...\n", direction == 1 ? "forward" : "backward");
}