//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Product structure
typedef struct Product {
    int id;
    char name[50];
    int quantity;
    float price;
} Product;

// Inventory array
Product inventory[100];

// Number of products in the inventory
int num_products = 0;

// Function to add a product to the inventory
void add_product(Product product) {
    // Check if the inventory is full
    if (num_products == 100) {
        printf("Error: Inventory is full. Cannot add product.\n");
        return;
    }

    // Add the product to the inventory
    inventory[num_products++] = product;
}

// Function to remove a product from the inventory
void remove_product(int id) {
    // Find the product in the inventory
    int index = -1;
    for (int i = 0; i < num_products; i++) {
        if (inventory[i].id == id) {
            index = i;
            break;
        }
    }

    // Check if the product was found
    if (index == -1) {
        printf("Error: Product not found. Cannot remove product.\n");
        return;
    }

    // Remove the product from the inventory
    for (int i = index; i < num_products - 1; i++) {
        inventory[i] = inventory[i + 1];
    }
    num_products--;
}

// Function to update a product in the inventory
void update_product(Product product) {
    // Find the product in the inventory
    int index = -1;
    for (int i = 0; i < num_products; i++) {
        if (inventory[i].id == product.id) {
            index = i;
            break;
        }
    }

    // Check if the product was found
    if (index == -1) {
        printf("Error: Product not found. Cannot update product.\n");
        return;
    }

    // Update the product in the inventory
    inventory[index] = product;
}

// Function to search for a product in the inventory
Product* search_product(int id) {
    // Find the product in the inventory
    for (int i = 0; i < num_products; i++) {
        if (inventory[i].id == id) {
            return &inventory[i];
        }
    }

    // Product not found
    return NULL;
}

// Function to print the inventory
void print_inventory() {
    printf("Inventory:\n");
    for (int i = 0; i < num_products; i++) {
        printf("%d %s %d %f\n", inventory[i].id, inventory[i].name, inventory[i].quantity, inventory[i].price);
    }
}

int main() {
    // Add some products to the inventory
    Product product1 = {1, "Apple", 10, 1.0};
    Product product2 = {2, "Orange", 20, 2.0};
    Product product3 = {3, "Banana", 30, 3.0};
    add_product(product1);
    add_product(product2);
    add_product(product3);

    // Print the inventory
    print_inventory();

    // Search for a product in the inventory
    Product* product = search_product(2);
    if (product != NULL) {
        printf("Product found: %d %s %d %f\n", product->id, product->name, product->quantity, product->price);
    } else {
        printf("Product not found.\n");
    }

    // Update a product in the inventory
    product->quantity = 50;
    update_product(*product);

    // Print the inventory again
    print_inventory();

    // Remove a product from the inventory
    remove_product(1);

    // Print the inventory one last time
    print_inventory();

    return 0;
}