//GEMINI-pro DATASET v1.0 Category: Time Travel Simulator ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the maximum number of years the user can travel
#define MAX_YEARS 100

// Define the minimum year the user can travel to
#define MIN_YEAR 1900

// Define the maximum year the user can travel to
#define MAX_YEAR 2100

// Define the number of possible destinations
#define NUM_DESTINATIONS 10

// Define the possible destinations
char *destinations[] = {
    "The Victorian Era",
    "The Roaring Twenties",
    "The Space Race",
    "The Digital Age",
    "The Future",
    "Ancient Egypt",
    "Medieval England",
    "The Renaissance",
    "The Enlightenment",
    "The Industrial Revolution"
};

// Define the structure of a time travel destination
typedef struct {
    int year;
    char *name;
} destination;

// Define the function to generate a random destination
destination generate_destination() {
    // Get a random year between the minimum and maximum years
    int year = (rand() % (MAX_YEAR - MIN_YEAR + 1)) + MIN_YEAR;

    // Get a random destination from the array of possible destinations
    int destination_index = rand() % NUM_DESTINATIONS;
    char *name = destinations[destination_index];

    // Return the destination
    return (destination) {
        .year = year,
        .name = name
    };
}

// Define the function to print a destination
void print_destination(destination destination) {
    // Print the year and name of the destination
    printf("Destination: %s (%d)\n", destination.name, destination.year);
}

// Define the main function
int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Generate a random destination
    destination destination = generate_destination();

    // Print the destination
    print_destination(destination);

    return 0;
}