//Falcon-180B DATASET v1.0 Category: Table Game ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PLAYERS 4
#define MAX_ROUNDS 5

typedef struct {
    char name[20];
    int score;
} Player;

void init_players(Player players[]) {
    for (int i = 0; i < MAX_PLAYERS; i++) {
        sprintf(players[i].name, "Player %d", i + 1);
        players[i].score = 0;
    }
}

void print_score(Player players[]) {
    printf("Scores:\n");
    for (int i = 0; i < MAX_PLAYERS; i++) {
        printf("%s: %d\n", players[i].name, players[i].score);
    }
}

int main() {
    srand(time(NULL));

    Player players[MAX_PLAYERS];
    init_players(players);

    int num_players = rand() % MAX_PLAYERS + 1;
    printf("Number of players: %d\n", num_players);

    for (int i = 0; i < num_players; i++) {
        players[i].score = rand() % 100 + 1;
    }

    printf("Round 1:\n");
    for (int i = 0; i < num_players; i++) {
        printf("%s rolls the dice and gets %d\n", players[i].name, rand() % 6 + 1);
    }

    int highest_score = 0;
    for (int i = 0; i < num_players; i++) {
        if (players[i].score > highest_score) {
            highest_score = players[i].score;
        }
    }

    printf("Highest score in round 1: %d\n", highest_score);

    for (int round = 2; round <= MAX_ROUNDS; round++) {
        printf("Round %d:\n", round);
        for (int i = 0; i < num_players; i++) {
            printf("%s rolls the dice and gets %d\n", players[i].name, rand() % 6 + 1);
        }

        highest_score = 0;
        for (int i = 0; i < num_players; i++) {
            if (players[i].score > highest_score) {
                highest_score = players[i].score;
            }
        }

        printf("Highest score in round %d: %d\n", round, highest_score);
    }

    print_score(players);

    return 0;
}