//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100

typedef struct product {
    int id;
    char name[50];
    int quantity;
    float price;
} product;

product inventory[MAX_PRODUCTS];
int num_products = 0;

void add_product(product p) {
    if (num_products == MAX_PRODUCTS) {
        printf("Error: Inventory is full!\n");
        return;
    }
    inventory[num_products++] = p;
}

void remove_product(int id) {
    int i;
    for (i = 0; i < num_products; i++) {
        if (inventory[i].id == id) {
            break;
        }
    }
    if (i == num_products) {
        printf("Error: Product not found!\n");
        return;
    }
    for (i; i < num_products - 1; i++) {
        inventory[i] = inventory[i + 1];
    }
    num_products--;
}

void update_product(product p) {
    int i;
    for (i = 0; i < num_products; i++) {
        if (inventory[i].id == p.id) {
            break;
        }
    }
    if (i == num_products) {
        printf("Error: Product not found!\n");
        return;
    }
    inventory[i] = p;
}

void print_inventory() {
    int i;
    printf("Inventory:\n");
    for (i = 0; i < num_products; i++) {
        printf("Product %d: %s (%d units, $%.2f each)\n", 
            inventory[i].id, inventory[i].name, inventory[i].quantity, inventory[i].price);
    }
}

int main() {
    product p1 = {1, "Apple", 10, 0.50};
    product p2 = {2, "Orange", 20, 0.75};
    product p3 = {3, "Banana", 30, 1.00};
    product p4 = {4, "Grape", 40, 1.25};

    add_product(p1);
    add_product(p2);
    add_product(p3);
    add_product(p4);
    print_inventory();
    remove_product(3);
    p4.price = 1.50;
    update_product(p4);
    print_inventory();
    return 0;
}