//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather conditions
typedef enum {
    SUNNY,
    CLOUDY,
    RAINING,
    SNOWING
} WeatherCondition;

// Get a random weather condition
WeatherCondition get_random_weather_condition() {
    int random_number = rand() % 4;
    switch (random_number) {
        case 0:
            return SUNNY;
        case 1:
            return CLOUDY;
        case 2:
            return RAINING;
        case 3:
            return SNOWING;
        default:
            return SUNNY;
    }
}

// Print the weather condition
void print_weather_condition(WeatherCondition weather_condition) {
    switch (weather_condition) {
        case SUNNY:
            printf("The weather is sunny.\n");
            break;
        case CLOUDY:
            printf("The weather is cloudy.\n");
            break;
        case RAINING:
            printf("The weather is raining.\n");
            break;
        case SNOWING:
            printf("The weather is snowing.\n");
            break;
    }
}

// Simulate the weather for a given number of days
void simulate_weather(int num_days) {
    // Seed the random number generator
    srand(time(NULL));

    // Simulate the weather for each day
    for (int i = 0; i < num_days; i++) {
        // Get a random weather condition
        WeatherCondition weather_condition = get_random_weather_condition();

        // Print the weather condition
        print_weather_condition(weather_condition);
    }
}

int main() {
    // Simulate the weather for 10 days
    simulate_weather(10);

    return 0;
}