//GEMINI-pro DATASET v1.0 Category: Socket programming ; Style: all-encompassing
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#define PORT 8080

int main() {
    int sockfd, newsockfd, len;
    struct sockaddr_in servaddr, cliaddr;
    char buffer[256];

    // Create a socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Set the server address
    bzero(&servaddr, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
    servaddr.sin_port = htons(PORT);

    // Bind the socket to the server address
    if (bind(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    if (listen(sockfd, 5) < 0) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    // Accept an incoming connection
    len = sizeof(cliaddr);
    if ((newsockfd = accept(sockfd, (struct sockaddr *) &cliaddr, &len)) < 0) {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    // Read the data from the client
    bzero(buffer, sizeof(buffer));
    if (read(newsockfd, buffer, sizeof(buffer)) < 0) {
        perror("read");
        exit(EXIT_FAILURE);
    }

    // Write the data back to the client
    if (write(newsockfd, buffer, sizeof(buffer)) < 0) {
        perror("write");
        exit(EXIT_FAILURE);
    }

    // Close the connection
    close(newsockfd);
    close(sockfd);

    return 0;
}