//LLAMA2-13B DATASET v1.0 Category: String manipulation ; Style: grateful
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define GRATITUDE_MAX_LEN 1024

void gratitude_split(char *str, char **words);
void gratitude_join(char **words, char *dest);

int main() {
    char *str = "I am so grateful for this opportunity! Thank you so much!";
    char *words[3];

    gratitude_split(str, words);
    printf("Original string: %s\n", str);
    printf("Words: ");
    gratitude_join(words, str);
    printf("\n");

    return 0;
}

void gratitude_split(char *str, char **words) {
    int i, j, len = strlen(str);
    char *token;

    for (i = 0; i < len; i++) {
        if (str[i] == ' ' || str[i] == '\n') {
            token = str + i;
            while (token > str && token[-1] == ' ') {
                token--;
            }
            *words = realloc(*words, (words[0] - *words) + 2);
            strcpy(words[0], token);
            words[0] += strlen(token);
            i += strlen(token) - 1;
        }
    }
}

void gratitude_join(char **words, char *dest) {
    int i, j, len = 0;

    for (i = 0; words[i]; i++) {
        len += strlen(words[i]) + 1;
    }
    dest = realloc(dest, len);
    for (i = 0; words[i]; i++) {
        strcat(dest, words[i]);
        strcat(dest, " ");
    }
    dest[len - 1] = '\0';
}