//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 16
#define HEIGHT 16

// Define a structure for our pixel
typedef struct {
    char character;
    char color; // Assuming colors are represented numerically
} Pixel;

// Function to generate a random character based on a simple predefined set
char generate_random_character() {
    const char characters[] = {' ', '.', ':', '*', 'o', '8', '#', '@'};
    return characters[rand() % (sizeof(characters) / sizeof(characters[0]))];
}

// Function to generate a random color
char generate_random_color() {
    const char colors[] = { 'R', 'G', 'B', 'Y', 'M', 'C', 'W' }; // Simply representing colors as single characters
    return colors[rand() % (sizeof(colors) / sizeof(colors[0]))];
}

// Function to create a new pixel
Pixel create_pixel() {
    Pixel pixel;
    pixel.character = generate_random_character();
    pixel.color = generate_random_color();
    return pixel;
}

// Function to generate a pixel art grid
void generate_pixel_art(Pixel art[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; ++i) {
        for (int j = 0; j < WIDTH; ++j) {
            art[i][j] = create_pixel();
        }
    }
}

// Function to display the pixel art on the console
void display_pixel_art(const Pixel art[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; ++i) {
        for (int j = 0; j < WIDTH; ++j) {
            // Color display simulation
            printf("\033[%dm%c ", art[i][j].color, art[i][j].character);
        }
        printf("\033[0m\n"); // Reset color after each line
    }
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Create a 2D array to store the pixel art
    Pixel pixel_art[HEIGHT][WIDTH];

    // Generate the pixel art
    generate_pixel_art(pixel_art);

    // Display the generated pixel art
    display_pixel_art(pixel_art);

    return 0;
}