//LLAMA2-13B DATASET v1.0 Category: Math exercise ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define a struct to hold a complex number
typedef struct {
    double real;
    double imag;
} complex;

// Define a function to add two complex numbers
complex add(complex a, complex b) {
    return (complex) {
        a.real + b.real,
        a.imag + b.imag
    };
}

// Define a function to multiply two complex numbers
complex multiply(complex a, complex b) {
    return (complex) {
        a.real * b.real - a.imag * b.imag,
        a.real * b.imag + a.imag * b.real
    };
}

// Define a function to calculate the magnitude of a complex number
double magnitude(complex a) {
    return sqrt(a.real * a.real + a.imag * a.imag);
}

// Define a function to calculate the angle of a complex number
double angle(complex a) {
    return atan2(a.imag, a.real);
}

int main() {
    // Create two complex numbers
    complex a = {3, 4};
    complex b = {2, 1};

    // Add the two complex numbers
    complex c = add(a, b);
    printf("a + b = %c + %c\n", a.real, a.imag);
    printf("c = %c + %c\n", c.real, c.imag);

    // Multiply the two complex numbers
    complex d = multiply(a, b);
    printf("a * b = %c + %c\n", a.real, a.imag);
    printf("d = %c + %c\n", d.real, d.imag);

    // Calculate the magnitude of the complex numbers
    double mag_a = magnitude(a);
    double mag_b = magnitude(b);
    double mag_c = magnitude(c);
    double mag_d = magnitude(d);
    printf("magnitude of a = %f\n", mag_a);
    printf("magnitude of b = %f\n", mag_b);
    printf("magnitude of c = %f\n", mag_c);
    printf("magnitude of d = %f\n", mag_d);

    // Calculate the angle of the complex numbers
    double ang_a = angle(a);
    double ang_b = angle(b);
    double ang_c = angle(c);
    double ang_d = angle(d);
    printf("angle of a = %f\n", ang_a);
    printf("angle of b = %f\n", ang_b);
    printf("angle of c = %f\n", ang_c);
    printf("angle of d = %f\n", ang_d);

    return 0;
}