//Gemma-7B DATASET v1.0 Category: Unit converter ; Style: futuristic
#include <stdio.h>
#include <math.h>

void cosmic_converter(double value, char unit, char target_unit) {
  double conversion_factor;
  switch (unit) {
    case 'y':
      conversion_factor = 1e24;
      break;
    case 'z':
      conversion_factor = 1e21;
      break;
    case 'a':
      conversion_factor = 1e18;
      break;
    case 'f':
      conversion_factor = 1e15;
      break;
    case 'p':
      conversion_factor = 1e12;
      break;
    case 't':
      conversion_factor = 1e9;
      break;
    case 's':
      conversion_factor = 1e6;
      break;
    case 'm':
      conversion_factor = 1e3;
      break;
    case 'cm':
      conversion_factor = 10;
      break;
    default:
      printf("Invalid unit.\n");
      return;
  }

  switch (target_unit) {
    case 'y':
      conversion_factor = 1e-24;
      break;
    case 'z':
      conversion_factor = 1e-21;
      break;
    case 'a':
      conversion_factor = 1e-18;
      break;
    case 'f':
      conversion_factor = 1e-15;
      break;
    case 'p':
      conversion_factor = 1e-12;
      break;
    case 't':
      conversion_factor = 1e-9;
      break;
    case 's':
      conversion_factor = 1e-6;
      break;
    case 'm':
      conversion_factor = 1e-3;
      break;
    case 'cm':
      conversion_factor = 10^-2;
      break;
    default:
      printf("Invalid target unit.\n");
      return;
  }

  double converted_value = value * conversion_factor;
  printf("%lf %s converted to %lf %s is %lf.\n", value, unit, target_unit, converted_value);
}

int main() {
  cosmic_converter(10, 'y', 'm');
  cosmic_converter(100, 'z', 's');
  cosmic_converter(1000, 'a', 'cm');

  return 0;
}