//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_WORKOUTS 3 // Number of workouts per week
#define NUM_DAYS 7 // Number of days per week
#define MAX_STEPS 10000 // Maximum number of steps per day
#define MAX_CALORIES 2000 // Maximum number of calories per day

typedef struct {
    char name[50];
    int age;
    int weight;
    int height;
    int steps[NUM_DAYS];
    int calories[NUM_DAYS];
} User;

void initUser(User* user) {
    user->age = 0;
    user->weight = 0;
    user->height = 0;
    for (int i = 0; i < NUM_DAYS; i++) {
        user->steps[i] = 0;
        user->calories[i] = 0;
    }
}

void printUserInfo(User* user) {
    printf("Name: %s\n", user->name);
    printf("Age: %d\n", user->age);
    printf("Weight: %d\n", user->weight);
    printf("Height: %d\n", user->height);
    for (int i = 0; i < NUM_DAYS; i++) {
        printf("Steps on day %d: %d\n", i+1, user->steps[i]);
        printf("Calories burned on day %d: %d\n", i+1, user->calories[i]);
    }
}

void updateUserInfo(User* user, int day, int steps, int calories) {
    user->steps[day] = steps;
    user->calories[day] = calories;
}

void printWorkoutPlan(int week) {
    printf("Week %d Workout Plan:\n", week);
    printf("Monday: Cardio - 30 minutes\n");
    printf("Tuesday: Strength Training - 3 sets of 10 reps\n");
    printf("Wednesday: Rest Day\n");
    printf("Thursday: HIIT - 20 minutes\n");
    printf("Friday: Yoga - 45 minutes\n");
    printf("Saturday: Cardio - 45 minutes\n");
    printf("Sunday: Rest Day\n");
}

int main() {
    User user;
    initUser(&user);

    int week = 1;
    while (week <= NUM_WORKOUTS) {
        printWorkoutPlan(week);
        for (int i = 0; i < NUM_DAYS; i++) {
            int steps = rand() % MAX_STEPS;
            int calories = steps * 10; // Assume 10 calories burned per step
            updateUserInfo(&user, i, steps, calories);
        }
        week++;
    }

    printUserInfo(&user);

    return 0;
}