//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    double x;
    double y;
} point;

typedef struct {
    point p1;
    point p2;
} line;

typedef struct {
    point center;
    double radius;
} circle;

// Function to check if a point is inside a circle
int is_inside_circle(point p, circle c) {
    double dx = p.x - c.center.x;
    double dy = p.y - c.center.y;
    double distance = sqrt(dx * dx + dy * dy);
    return distance <= c.radius;
}

// Function to check if a line intersects a circle
int does_line_intersect_circle(line l, circle c) {
    // Check if the line passes through the center of the circle
    double dx = l.p2.x - l.p1.x;
    double dy = l.p2.y - l.p1.y;
    double t = ((c.center.x - l.p1.x) * dx + (c.center.y - l.p1.y) * dy) / (dx * dx + dy * dy);
    if (t < 0 || t > 1) {
        return 0;
    }
    point p = {l.p1.x + t * dx, l.p1.y + t * dy};
    return is_inside_circle(p, c);
}

int main() {
    // Define a circle
    circle c = {{0, 0}, 5};

    // Define a line
    line l = {{0, -5}, {0, 5}};

    // Check if the line intersects the circle
    int does_intersect = does_line_intersect_circle(l, c);

    // Print the result
    printf("Does the line intersect the circle? %s\n", does_intersect ? "Yes" : "No");

    return 0;
}