//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define NUM_LIGHTS 5
#define MAX_BRIGHTNESS 255
#define MIN_BRIGHTNESS 0
#define STEP_SIZE 5

// Initialize the lights to be off
int lights[NUM_LIGHTS] = {0};

// Function to set the brightness of a light
void set_light_brightness(int light_index, int brightness) {
    lights[light_index] = brightness;
}

// Function to turn a light on or off
void toggle_light(int light_index) {
    if (lights[light_index] == 0) {
        set_light_brightness(light_index, MAX_BRIGHTNESS);
    } else {
        set_light_brightness(light_index, 0);
    }
}

// Function to print the current state of the lights
void print_lights() {
    for (int i = 0; i < NUM_LIGHTS; i++) {
        printf("Light %d: %d\n", i + 1, lights[i]);
    }
}

// Function to simulate a sunrise effect
void sunrise_effect() {
    for (int i = 0; i < NUM_LIGHTS; i++) {
        for (int j = MIN_BRIGHTNESS; j <= MAX_BRIGHTNESS; j += STEP_SIZE) {
            set_light_brightness(i, j);
            usleep(50000); // Sleep for 50ms
        }
    }
}

// Function to simulate a sunset effect
void sunset_effect() {
    for (int i = MAX_BRIGHTNESS; i >= MIN_BRIGHTNESS; i -= STEP_SIZE) {
        for (int j = 0; j < NUM_LIGHTS; j++) {
            set_light_brightness(j, i);
            usleep(50000); // Sleep for 50ms
        }
    }
}

int main() {
    // Initialize the lights to be off
    for (int i = 0; i < NUM_LIGHTS; i++) {
        set_light_brightness(i, 0);
    }

    // Print the initial state of the lights
    printf("Initial state:\n");
    print_lights();

    // Simulate a sunrise effect
    printf("\nSimulating a sunrise...\n");
    sunrise_effect();

    // Print the final state of the lights
    printf("\nFinal state:\n");
    print_lights();

    // Toggle each light on and off
    for (int i = 0; i < NUM_LIGHTS; i++) {
        toggle_light(i);
        usleep(100000); // Sleep for 100ms
    }

    // Simulate a sunset effect
    printf("\nSimulating a sunset...\n");
    sunset_effect();

    // Print the final state of the lights
    printf("\nFinal state:\n");
    print_lights();

    return 0;
}