//GEMINI-pro DATASET v1.0 Category: Internet Speed Test Application ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define DEFAULT_PORT 80
#define DEFAULT_HOST "www.google.com"
#define BUFFER_SIZE 1024

// Function to calculate the time difference between two timevals
int timeval_subtract(struct timeval *result, struct timeval *t1, struct timeval *t2) {
    if (t1->tv_sec > t2->tv_sec)
        return -1;
    if ((t1->tv_sec == t2->tv_sec) && (t1->tv_usec > t2->tv_usec))
        return -1;
    result->tv_sec = t2->tv_sec - t1->tv_sec;
    result->tv_usec = t2->tv_usec - t1->tv_usec;
    if (result->tv_usec < 0) {
        result->tv_sec--;
        result->tv_usec += 1000000;
    }
    return 0;
}

// Function to perform the speed test
int speed_test(char *host, int port) {
    int sockfd, n;
    struct sockaddr_in servaddr;
    struct timeval start, end, result;
    char buffer[BUFFER_SIZE];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket");
        return -1;
    }

    // Set the server address
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(port);
    servaddr.sin_addr.s_addr = inet_addr(host);

    // Connect to the server
    if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
        perror("connect");
        return -1;
    }

    // Send a request to the server
    memset(buffer, 'a', BUFFER_SIZE);
    gettimeofday(&start, NULL);
    n = write(sockfd, buffer, BUFFER_SIZE);
    if (n < 0) {
        perror("write");
        return -1;
    }

    // Receive the response from the server
    memset(buffer, 0, BUFFER_SIZE);
    n = read(sockfd, buffer, BUFFER_SIZE);
    if (n < 0) {
        perror("read");
        return -1;
    }
    gettimeofday(&end, NULL);

    // Calculate the time difference between the start and end times
    timeval_subtract(&result, &end, &start);

    // Calculate the speed in bytes per second
    int speed = (BUFFER_SIZE * 8) / result.tv_sec;

    // Close the socket
    close(sockfd);

    return speed;
}

// Function to print the help message
void print_help() {
    printf("Usage: speed_test [options]\n");
    printf("Options:\n");
    printf("  -h, --host HOST      The hostname or IP address of the server to test (default: www.google.com)\n");
    printf("  -p, --port PORT      The port number of the server to test (default: 80)\n");
    printf("  -h, --help          Print this help message\n");
}

// Main function
int main(int argc, char *argv[]) {
    char *host = DEFAULT_HOST;
    int port = DEFAULT_PORT;
    int speed;

    // Parse the command line arguments
    int c;
    while ((c = getopt(argc, argv, "h:p:")) != -1) {
        switch (c) {
            case 'h':
                host = optarg;
                break;
            case 'p':
                port = atoi(optarg);
                break;
            case '?':
                if (optopt == 'h' || optopt == 'p')
                    fprintf(stderr, "Option -%c requires an argument.\n", optopt);
                else
                    fprintf(stderr, "Unknown option '-%c'.\n", optopt);
            default:
                print_help();
                return 1;
        }
    }

    // Perform the speed test
    speed = speed_test(host, port);
    if (speed < 0) {
        fprintf(stderr, "Speed test failed.\n");
        return 1;
    }

    // Print the results
    printf("Speed: %d bytes/s\n", speed);

    return 0;
}