//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: Alan Turing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Robot movement commands
enum commands {
    FORWARD,
    BACKWARD,
    LEFT,
    RIGHT,
    STOP
};

// Robot movement states
enum states {
    IDLE,
    MOVING
};

// Robot struct
struct robot {
    int x;
    int y;
    enum commands command;
    enum states state;
};

// Function to move the robot
void move_robot(struct robot *robot) {
    switch (robot->command) {
        case FORWARD:
            robot->y++;
            break;
        case BACKWARD:
            robot->y--;
            break;
        case LEFT:
            robot->x--;
            break;
        case RIGHT:
            robot->x++;
            break;
        case STOP:
            robot->state = IDLE;
            break;
    }
}

// Function to print the robot's position
void print_robot_position(struct robot *robot) {
    printf("Robot position: (%d, %d)\n", robot->x, robot->y);
}

// Function to get a command from the user
enum commands get_command(void) {
    char command[10];
    printf("Enter a command (forward, backward, left, right, stop): ");
    scanf("%s", command);
    if (strcmp(command, "forward") == 0) {
        return FORWARD;
    } else if (strcmp(command, "backward") == 0) {
        return BACKWARD;
    } else if (strcmp(command, "left") == 0) {
        return LEFT;
    } else if (strcmp(command, "right") == 0) {
        return RIGHT;
    } else if (strcmp(command, "stop") == 0) {
        return STOP;
    } else {
        printf("Invalid command!\n");
        return get_command();
    }
}

// Main function
int main(void) {
    // Create a new robot
    struct robot robot;

    // Set the robot's initial position
    robot.x = 0;
    robot.y = 0;

    // Set the robot's initial state
    robot.state = IDLE;

    // Main loop
    while (robot.state != IDLE) {
        // Get a command from the user
        robot.command = get_command();

        // Move the robot
        move_robot(&robot);

        // Print the robot's position
        print_robot_position(&robot);
    }

    return 0;
}