//GEMINI-pro DATASET v1.0 Category: Mailing list manager ; Style: retro
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of subscribers
#define MAX_SUBSCRIBERS 100

// Define the structure of a subscriber
typedef struct subscriber {
  char name[50];
  char email[50];
} subscriber;

// Create the mailing list
subscriber subscribers[MAX_SUBSCRIBERS];

// Initialize the mailing list
int num_subscribers = 0;

// Function to add a subscriber to the mailing list
void add_subscriber(char *name, char *email) {
  // Check if the mailing list is full
  if (num_subscribers >= MAX_SUBSCRIBERS) {
    printf("Error: The mailing list is full.\n");
    return;
  }

  // Add the subscriber to the mailing list
  strcpy(subscribers[num_subscribers].name, name);
  strcpy(subscribers[num_subscribers].email, email);
  num_subscribers++;
}

// Function to remove a subscriber from the mailing list
void remove_subscriber(char *email) {
  // Find the subscriber in the mailing list
  int i;
  for (i = 0; i < num_subscribers; i++) {
    if (strcmp(subscribers[i].email, email) == 0) {
      break;
    }
  }

  // Check if the subscriber was found
  if (i == num_subscribers) {
    printf ("Error: The subscriber was not found.\n");
    return;
  }

  // Remove the subscriber from the mailing list
  for (i = i + 1; i < num_subscribers; i++) {
    subscribers[i-1] = subscribers[i];
  }

  num_subscribers--;
}

// Function to send a message to the mailing list
void send_message(char *subject, char *body) {
  // Send the message to each subscriber
  int i;
  for (i = 0; i < num_subscribers; i++) {
    printf("To: %s <%s>\n", subscribers[i].name, subscribers[i].email);
    printf("Subject: %s\n", subject);
    printf("%s\n", body);
  }
}

// Main function
int main() {
  // Add some subscribers to the mailing list
  add_subscriber("John Doe", "john.doe@example.com");
  add_subscriber("Jane Doe", "jane.doe@example.com");
  add_subscriber("Bob Smith", "bob.smith@example.com");

  // Send a message to the mailing list
  send_message("Hello, world!", "This is a test message.");

  // Remove a subscriber from the mailing list
  remove_subscriber("john.doe@example.com");

  // Send another message to the mailing list
  send_message("Goodbye, world!", "This is the last test message.");

  return 0;
}