//GEMINI-pro DATASET v1.0 Category: Cryptography Implementation ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/evp.h>

// Custom encryption function using AES-256-CBC
int encrypt(unsigned char *plaintext, int plaintext_len, unsigned char *key,
            unsigned char *iv, unsigned char *ciphertext) {
    EVP_CIPHER_CTX *ctx;
    int ciphertext_len;

    // Create and initialize the context
    if (!(ctx = EVP_CIPHER_CTX_new())) {
        return -1;
    }

    // Initialize the cipher for encryption with the specified key and IV
    if (EVP_EncryptInit_ex(ctx, EVP_aes_256_cbc(), NULL, key, iv) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Perform the encryption
    if (EVP_EncryptUpdate(ctx, ciphertext, &ciphertext_len, plaintext,
                           plaintext_len) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Finalize the encryption
    if (EVP_EncryptFinal_ex(ctx, ciphertext + ciphertext_len,
                             &ciphertext_len) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Free the context
    EVP_CIPHER_CTX_free(ctx);

    return ciphertext_len;
}

// Custom decryption function using AES-256-CBC
int decrypt(unsigned char *ciphertext, int ciphertext_len, unsigned char *key,
            unsigned char *iv, unsigned char *plaintext) {
    EVP_CIPHER_CTX *ctx;
    int plaintext_len;

    // Create and initialize the context
    if (!(ctx = EVP_CIPHER_CTX_new())) {
        return -1;
    }

    // Initialize the cipher for decryption with the specified key and IV
    if (EVP_DecryptInit_ex(ctx, EVP_aes_256_cbc(), NULL, key, iv) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Perform the decryption
    if (EVP_DecryptUpdate(ctx, plaintext, &plaintext_len, ciphertext,
                           ciphertext_len) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Finalize the decryption
    if (EVP_DecryptFinal_ex(ctx, plaintext + plaintext_len,
                             &plaintext_len) != 1) {
        EVP_CIPHER_CTX_free(ctx);
        return -1;
    }

    // Free the context
    EVP_CIPHER_CTX_free(ctx);

    return plaintext_len;
}

// Generate a random initialization vector (IV)
void generate_iv(unsigned char *iv) {
    int i;

    // Seed the random number generator
    srand(time(NULL));

    // Generate a random IV
    for (i = 0; i < 16; i++) {
        iv[i] = rand() % 256;
    }
}

int main() {
    unsigned char plaintext[] = "Hello, world!";
    unsigned char key[] = "0123456789abcdef0123456789abcdef";
    unsigned char iv[16];
    unsigned char ciphertext[1024];
    int ciphertext_len;
    int plaintext_len;

    // Generate a random IV
    generate_iv(iv);

    // Encrypt the plaintext
    ciphertext_len = encrypt(plaintext, strlen(plaintext), key, iv, ciphertext);
    if (ciphertext_len == -1) {
        printf("Error encrypting the plaintext\n");
        return -1;
    }

    // Decrypt the ciphertext
    plaintext_len = decrypt(ciphertext, ciphertext_len, key, iv, plaintext);
    if (plaintext_len == -1) {
        printf("Error decrypting the ciphertext\n");
        return -1;
    }

    // Print the decrypted plaintext
    printf("Decrypted plaintext: %s\n", plaintext);

    return 0;
}