//Falcon-180B DATASET v1.0 Category: Time Travel Simulator ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_EVENTS 100
#define MAX_TIME 100

typedef struct {
    int time;
    int type;
    int data;
} Event;

void add_event(Event* events, int num_events, int time, int type, int data) {
    if (num_events >= MAX_EVENTS) {
        printf("Error: Too many events.\n");
        exit(1);
    }
    events[num_events].time = time;
    events[num_events].type = type;
    events[num_events].data = data;
    num_events++;
}

void time_travel(Event* events, int num_events, int start_time, int end_time) {
    int current_time = start_time;
    while (current_time <= end_time) {
        int i;
        for (i = 0; i < num_events; i++) {
            if (events[i].time == current_time) {
                switch (events[i].type) {
                    case 1:
                        printf("You traveled back in time by %d seconds.\n", events[i].data);
                        break;
                    case 2:
                        printf("You traveled forward in time by %d seconds.\n", events[i].data);
                        break;
                    case 3:
                        printf("You caused a paradox and altered the timeline!\n");
                        break;
                    default:
                        printf("Unknown time travel event.\n");
                        break;
                }
            }
        }
        current_time++;
    }
}

int main() {
    Event events[MAX_EVENTS];
    int num_events = 0;

    add_event(events, num_events, 5, 1, 10);
    add_event(events, num_events, 10, 2, 5);
    add_event(events, num_events, 15, 1, 5);
    add_event(events, num_events, 20, 3, 0);

    time_travel(events, num_events, 0, 25);

    return 0;
}