//LLAMA2-13B DATASET v1.0 Category: Socket programming ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define BUFFER_SIZE 1024

int main() {
    int sock;
    struct sockaddr_in server, client;
    socklen_t client_len = sizeof(client);
    char buffer[BUFFER_SIZE];

    // Create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Socket creation failed");
        exit(1);
    }

    // Set address and port number of the server
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = inet_addr("127.0.0.1");
    server.sin_port = htons(8080);

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("Connection failed");
        exit(1);
    }

    // Send a message to the server
    strcpy(buffer, "Hello, server!");
    send(sock, buffer, strlen(buffer), 0);

    // Receive a message from the server
    recv(sock, buffer, BUFFER_SIZE, 0);
    printf("Received message: %s\n", buffer);

    // Send another message to the server
    strcpy(buffer, "Hello again, server!");
    send(sock, buffer, strlen(buffer), 0);

    // Receive another message from the server
    recv(sock, buffer, BUFFER_SIZE, 0);
    printf("Received message: %s\n", buffer);

    // Close the socket
    close(sock);

    return 0;
}