//MISTRAL-7B DATASET v1.0 Category: Automated Fortune Teller ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#define MAX_FORTUNES 10
#define FORTUNE_LENGTH 80

// Linus Torvalds style comments
/*
 * Fortune struct holds a fortune and a probability of being chosen
 */
typedef struct {
    char fortune[FORTUNE_LENGTH];
    int probability;
} fortune;

/*
 * Array of fortunes, initialized with some Torvaldsian wisdom
 */
fortune fortunes[MAX_FORTUNES] = {
    {"The key to success is to focus our conscious mind on things we desire. " \
     "Visualize those things often. " \
     "Remember, the mind reflects its thoughts into reality.", 70},

    {"Patience is a virtue, but persistence is its companion.", 85},

    {"The only true wisdom is in knowing you know nothing. ", 60},

    {"I'm just here so I don't get fined for not showing up.", 30},

    {"I'm a programmer, not a magician. I can't make something out of nothing.", 20},

    {"I don't make mistakes. I execute complex algorithms with unexpected results.", 5},

    {"I'd rather have a bottle in front of me than a frontal lobotomy.", 40},

    {"Good things come to those who wait, but better things come to those who make them happen.", 90},

    {"Always look on the bright side of life.", 10},

    {"A smooth sea never made a skilled sailor.", 25}
};

/*
 * Randomly selects and prints a fortune
 */
void get_fortune(void) {
    int index, rand_num;
    fortune *selected_fortune;

    /* Initialize random seed */
    srand(time(NULL));

    /* Generate random number to select fortune index */
    rand_num = rand() % MAX_FORTUNES;

    /* Point to selected fortune */
    selected_fortune = &fortunes[rand_num];

    /* Print the fortune */
    printf("\n%s\n", selected_fortune->fortune);
}

/*
 * Entry point of the program
 */
int main() {
    get_fortune();
    return 0;
}