//GEMINI-pro DATASET v1.0 Category: Word Count Tool ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Declare our star-crossed functions
int count_words(char *text);
void print_word_count(int count);

int main() {
  // Set the stage for our tragic tale
  char *text = "Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.";

  // Count the words in the prologue
  int word_count = count_words(text);

  // Print our tragic word count
  print_word_count(word_count);

  return 0;
}

// Count the words in the given text
int count_words(char *text) {
  int count = 0;
  int in_word = 0;

  for (int i = 0; text[i] != '\0'; i++) {
    // If we encounter a non-whitespace character, we are in a word
    if (!isspace(text[i])) {
      if (!in_word) {
        count++;
      }
      in_word = 1;
    }
    // If we encounter a whitespace character, we are not in a word
    else {
      in_word = 0;
    }
  }

  return count;
}

// Print the word count with a flourish
void print_word_count(int count) {
  printf("But wherefore art thou, word count?\nDeny thy father and refuse thy name;\nOr, if thou wilt not, be but sworn my love,\nAnd I'll no longer be a Capulet.\n");
  printf("For words, dear words, there is no east or west,\nNor Montague nor Capulet in them;\nOnly the tragic tale of love and hate\nThat fills the pages of Verona's scene.\n\n");
  printf("And so, fair word count, I bid thee adieu,\nWith a heavy heart and a tear in mine eye.\nMay thy journey be filled with joy and cheer,\nAnd may thy memory forever live.\n\n");
  printf("Word count: %d\n", count);
}