//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <math.h>

#define MAX_SENSORS 10
#define MAX_SENSOR_NAME_SIZE 20
#define MAX_SENSOR_VALUE_SIZE 20

typedef struct {
    char name[MAX_SENSOR_NAME_SIZE];
    double value;
} Sensor;

int numSensors = 0;
Sensor sensors[MAX_SENSORS];

void addSensor(char* name, double value) {
    if (numSensors >= MAX_SENSORS) {
        printf("Error: Maximum number of sensors reached\n");
        return;
    }

    strncpy(sensors[numSensors].name, name, MAX_SENSOR_NAME_SIZE);
    sensors[numSensors].value = value;

    numSensors++;
}

void updateSensorValue(int sensorIndex, double value) {
    if (sensorIndex < 0 || sensorIndex >= numSensors) {
        printf("Error: Invalid sensor index\n");
        return;
    }

    sensors[sensorIndex].value = value;
}

void printSensors() {
    printf("Sensors:\n");
    for (int i = 0; i < numSensors; i++) {
        printf("%s: %.2f\n", sensors[i].name, sensors[i].value);
    }
}

int main() {
    // Add sensors
    addSensor("CPU", 50.0);
    addSensor("GPU", 60.0);
    addSensor("HDD", 40.0);

    // Print sensors
    printSensors();

    // Update sensor values
    updateSensorValue(0, 55.0);
    updateSensorValue(1, 65.0);
    updateSensorValue(2, 45.0);

    // Print sensors
    printSensors();

    return 0;
}