//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

// Check if a number is even or odd using bitwise AND (&)
int is_even(uint32_t num) {
    return !(num & 1);
}

// Check if a number is a power of 2 using bitwise AND (&)
int is_power_of_2(uint32_t num) {
    return (num != 0) && ((num & (num - 1)) == 0);
}

// Count the number of set bits in a number using bitwise AND (&) and bitwise shift (<<)
int count_set_bits(uint32_t num) {
    int count = 0;
    while (num) {
        if (num & 1) {
            count++;
        }
        num >>= 1;
    }
    return count;
}

// Reverse the bits of a number using bitwise XOR (^) and bitwise shift (<<)
uint32_t reverse_bits(uint32_t num) {
    uint32_t reversed = 0;
    int i;
    for (i = 0; i < 32; i++) {
        reversed |= ((num >> i) & 1) << (31 - i);
    }
    return reversed;
}

// Swap two numbers using bitwise XOR (^)
void swap_numbers(uint32_t *a, uint32_t *b) {
    *a ^= *b;
    *b ^= *a;
    *a ^= *b;
}

// Get the maximum of two numbers using bitwise AND (&) and bitwise OR (|)
uint32_t max(uint32_t a, uint32_t b) {
    return (a & b) | (~a & b);
}

// Get the minimum of two numbers using bitwise AND (&) and bitwise XOR (^)
uint32_t min(uint32_t a, uint32_t b) {
    return (a & b) ^ (~a & b);
}

// Check if two numbers have the same sign using bitwise XOR (^)
int have_same_sign(int a, int b) {
    return !((a ^ b) & 0x80000000);
}

// Check if a number is negative using bitwise AND (&)
int is_negative(int num) {
    return (num & 0x80000000);
}

// Get the absolute value of a number using bitwise XOR (^) and bitwise AND (&)
int abs(int num) {
    return (num ^ (num >> 31)) & 0x7fffffff;
}

int main() {
    // Print some examples
    printf("Is 10 even? %d\n", is_even(10));
    printf("Is 11 a power of 2? %d\n", is_power_of_2(11));
    printf("Number of set bits in 15: %d\n", count_set_bits(15));
    printf("Reversed bits of 12345: %u\n", reverse_bits(12345));
    uint32_t a = 10, b = 20;
    printf("Before swap: a = %u, b = %u\n", a, b);
    swap_numbers(&a, &b);
    printf("After swap: a = %u, b = %u\n", a, b);
    printf("Maximum of 10 and 20: %u\n", max(10, 20));
    printf("Minimum of 10 and 20: %u\n", min(10, 20));
    printf("Do 10 and 20 have the same sign? %d\n", have_same_sign(10, 20));
    printf("Is -10 negative? %d\n", is_negative(-10));
    printf("Absolute value of -10: %d\n", abs(-10));
    return 0;
}