//GEMINI-pro DATASET v1.0 Category: Tower of Hanoi Problem ; Style: post-apocalyptic
// In the desolate wasteland, where rust reigns and hope flickers like a dying ember, a sinister puzzle emerged from the depths of ruin: the Tower of Hanoi.

// Amidst the crumbling skyscrapers and twisted metal, a lone scavenger named Ash wandered, tormented by the legend of the cursed tower. It was said that only the most cunning, with nerves of steel, could conquer its formidable challenge.

// As Ash approached the towering structure, the wind howled like a banshee, carrying the echoes of forgotten horrors. Three rusted rods, each adorned with a stack of ancient discs, pierced the desolate ground.

// Legend had it that the discs, once adorned with vibrant colors, had long ago been reduced to dull, lifeless remnants of a bygone era. Yet, their weight bore down upon Ash with an oppressive presence.

// With a steely gaze and a heart filled with both trepidation and determination, Ash embarked on his perilous quest.

#define NUM_DISCS 5

// The gnarled rods that hold the discs of doom
char rods[3] = { 'A', 'B', 'C' };

// The ritual of moving discs commences.
void move_discs(int num_discs, char from_rod, char to_rod, char via_rod) {
  // If there's only one disc, move it to the desired rod.
  if (num_discs == 1) {
    printf("Move disc 1 from rod %c to rod %c\n", from_rod, to_rod);
    return;
  }

  // Move the top 'num_discs - 1' discs to the via rod.
  move_discs(num_discs - 1, from_rod, via_rod, to_rod);

  // Move the largest disc to the destination rod.
  printf("Move disc %d from rod %c to rod %c\n", num_discs, from_rod, to_rod);

  // Move the 'num_discs - 1' discs from the via rod to the destination rod.
  move_discs(num_discs - 1, via_rod, to_rod, from_rod);
}

int main() {
  // The desolate wasteland whispers tales of the Tower of Hanoi.
  printf("In the post-apocalyptic realm, the Tower of Hanoi stands as a testament to despair.\n");

  // Ash, a weary survivor, confronts the grim challenge.
  printf("Ash, the solitary scavenger, ventures to conquer the formidable tower.\n");

  // The rusted rods and ancient discs bear witness to the passage of time.
  printf("With trembling hands, Ash surveys the three rods and the discs that lie upon them.\n");

  // The ritual of disc movement unfolds in a haunting silence.
  move_discs(NUM_DISCS, rods[0], rods[2], rods[1]);

  // Victory echoes through the wasteland as Ash vanquishes the cursed tower.
  printf("By the ancient gods, Ash has triumphed over the Tower of Hanoi!\n");

  // The scavenger's spirit, forged in the fires of adversity, shines like a beacon in the darkness.
  printf("In the desolate wasteland, hope still flickers, as Ash's unwavering resolve inspires those who dare to dream.\n");

  return 0;
}