//GPT-4o-mini DATASET v1.0 Category: Genome Sequencing Simulator ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define SEQUENCE_LENGTH 20
#define NUM_SEQUENCES 5
#define BASES "ACGT"

void generateRandomSequence(char* sequence) {
    for (int i = 0; i < SEQUENCE_LENGTH; ++i) {
        sequence[i] = BASES[rand() % 4]; // Choose a random base from A, C, G, T
    }
    sequence[SEQUENCE_LENGTH] = '\0'; // Null-terminate the string
}

void printFunnyCommentary(int sequenceNum) {
    char* comments[] = {
        "This sequence is more twisted than a pretzel!",
        "Warning: May contain traces of dinosaur DNA!",
        "Caution: Unstable and will likely mutate at any moment!",
        "Looks like we got ourselves a purebred nerd gene!",
        "If this DNA had a personality, it would be a squash!",
        "Is it just me, or does this sequence feel...extra spicy?",
        "Somebody call the gene police, this one's illegal!",
        "A classic case of a double helix taking a holiday!",
        "Almost as chaotic as my sock drawer!",
        "I feel like this sequence has more drama than reality TV!"
    };

    printf("Sequence %d: %s\n", sequenceNum, comments[sequenceNum % 10]);
}

void simulateGenomeSequencing() {
    // Seed the random number generator for different results each run
    srand(time(0));

    printf("Welcome to the Totally Serious Genome Sequencing Simulator!\n");
    printf("Hold onto your lab coats, because things are about to get DNAlicious!\n\n");

    // Create a random sequence of DNA
    for (int i = 0; i < NUM_SEQUENCES; ++i) {
        char sequence[SEQUENCE_LENGTH + 1]; // +1 for the null terminator
        generateRandomSequence(sequence);
        printf("Sequence %d: %s\n", i + 1, sequence);
        printFunnyCommentary(i);
        printf("\n");
    }

    printf("Congratulations! You've just simulated %d sequences!\n", NUM_SEQUENCES);
    printf("If only life were as simple and straightforward as DNA sequencing...\n");
    printf("Good luck explaining this to your pet goldfish!\n");
}

int main() {
    simulateGenomeSequencing();
    return 0;
}