//GEMINI-pro DATASET v1.0 Category: Stock market tracker ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Declare the structure to store stock data
typedef struct stock {
    char symbol[10];
    float price;
    float change;
    float percent_change;
    char exchange[10];
} stock;

// Declare the function to print the stock data
void print_stock(stock *s) {
    printf("Symbol: %s\n", s->symbol);
    printf("Price: $%.2f\n", s->price);
    printf("Change: $%.2f\n", s->change);
    printf("Percent Change: %.2f%%\n", s->percent_change);
    printf("Exchange: %s\n\n", s->exchange);
}

// Declare the function to compare two stocks by their percent change
int compare_stocks(const void *a, const void *b) {
    stock *sa = (stock *)a;
    stock *sb = (stock *)b;
    return (sa->percent_change > sb->percent_change) - (sa->percent_change < sb->percent_change);
}

// Declare the main function
int main() {
    // Create an array of stocks
    stock stocks[] = {
        {"AAPL", 123.45, 1.23, 1.00, "NASDAQ"},
        {"GOOG", 1000.00, 5.00, 0.50, "NASDAQ"},
        {"AMZN", 2000.00, 10.00, 0.50, "NASDAQ"},
        {"MSFT", 250.00, 2.50, 1.00, "NASDAQ"},
        {"FB", 150.00, 1.50, 1.00, "NASDAQ"}
    };

    // Print the original order of the stocks
    printf("Original Order:\n");
    for (int i = 0; i < 5; i++) {
        print_stock(&stocks[i]);
    }

    // Sort the stocks by their percent change
    qsort(stocks, 5, sizeof(stock), compare_stocks);

    // Print the sorted order of the stocks
    printf("\nSorted Order:\n");
    for (int i = 0; i < 5; i++) {
        print_stock(&stocks[i]);
    }

    return 0;
}