//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: enthusiastic
#include <stdio.h>
#include <stdbool.h>

#define N 5

// Function to print the solution path
void printSolution(int sol[N][N]) {
    printf("Found the path through the maze!\n");
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            printf(" %d ", sol[i][j]);
        }
        printf("\n");
    }
    printf("Yay! We made it through!\n");
}

// Function to check if x, y is a valid move
bool isSafe(int maze[N][N], int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y] == 1);
}

// Recursive function to solve the maze using backtracking
bool solveMazeUtil(int maze[N][N], int x, int y, int sol[N][N]) {
    // If (x, y) is the bottom right corner, we have found a solution!
    if (x == N - 1 && y == N - 1) {
        sol[x][y] = 1;
        return true;
    }
    
    // Check if maze[x][y] is valid
    if (isSafe(maze, x, y)) {
        // Mark x,y as part of solution path
        sol[x][y] = 1;

        // Move forward in x direction
        if (solveMazeUtil(maze, x + 1, y, sol)) {
            return true;
        }

        // If moving in x direction doesn't give us a solution then
        // move down in y direction
        if (solveMazeUtil(maze, x, y + 1, sol)) {
            return true;
        }

        // If none of the above movements works then BACKTRACK
        sol[x][y] = 0; // unmark x,y as part of solution path
    }
    return false;
}

// Function to solve the maze
bool solveMaze(int maze[N][N]) {
    int sol[N][N] = { { 0, 0, 0, 0, 0 },
                      { 0, 0, 0, 0, 0 },
                      { 0, 0, 0, 0, 0 },
                      { 0, 0, 0, 0, 0 },
                      { 0, 0, 0, 0, 0 } };

    if (solveMazeUtil(maze, 0, 0, sol) == false) {
        printf("Oops! No path found through the maze!\n");
        return false;
    }

    printSolution(sol);
    return true;
}

// Main function to drive the maze solver
int main() {
    // Building a magical maze to solve!
    int maze[N][N] = { { 1, 0, 0, 0, 0 },
                       { 1, 1, 0, 1, 0 },
                       { 0, 1, 0, 0, 1 },
                       { 0, 1, 1, 1, 1 },
                       { 0, 0, 0, 0, 1 } };

    printf("Welcome to the Maze Route Finder!\n");
    printf("Let's embark on a thrilling adventure!\n\n");

    // Solve the maze and discover the route!
    solveMaze(maze);

    return 0;
}