//Falcon-180B DATASET v1.0 Category: Database Indexing System ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of elements in the database
#define MAX_ELEMENTS 1000

// Define the structure of each element in the database
typedef struct {
    int key;
    char value[50];
} element;

// Define the database as an array of elements
element database[MAX_ELEMENTS];

// Define the number of elements currently in the database
int num_elements = 0;

// Define the function to add an element to the database
void add_element(int key, char* value) {
    if (num_elements >= MAX_ELEMENTS) {
        printf("Database is full!\n");
        return;
    }
    database[num_elements].key = key;
    strcpy(database[num_elements].value, value);
    num_elements++;
}

// Define the function to search for an element in the database
int search_element(int key) {
    for (int i = 0; i < num_elements; i++) {
        if (database[i].key == key) {
            return i;
        }
    }
    return -1;
}

// Define the function to print the entire database
void print_database() {
    for (int i = 0; i < num_elements; i++) {
        printf("%d - %s\n", database[i].key, database[i].value);
    }
}

// Define the main function
int main() {
    // Initialize the database with some elements
    add_element(1, "John Doe");
    add_element(2, "Jane Smith");
    add_element(3, "Bob Johnson");

    // Print the database
    print_database();

    // Search for an element in the database
    int index = search_element(2);
    if (index!= -1) {
        printf("Element found at index %d\n", index);
    } else {
        printf("Element not found\n");
    }

    return 0;
}