//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>

#define MAX_PACKET_SIZE 65536
#define ERR_BUF_SIZE PCAP_ERRBUF_SIZE

// Function to process each captured packet
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Captured Packet Length: %d bytes\n", header->len);
    printf("Packet Dump:\n");

    // Print the packet data in hexadecimal format
    for (int i = 0; i < header->len; i++) {
        if (i % 16 == 0) {
            if (i != 0) {
                printf("\n");
            }
            printf("0x%04x: ", i);
        }
        printf("%02x ", packet[i]);
    }
    printf("\n\n");
}

// Main function for the packet sniffer
int main(int argc, char **argv) {
    char *dev;                       // The device to capture from
    char errbuf[ERR_BUF_SIZE];      // Error string buffer
    pcap_t *handle;                 // Handle for the pcap interface

    // Check if the user has provided a device name or needs a default
    if (argc == 2) {
        dev = argv[1];
    } else {
        // Find the first available device
        dev = pcap_lookupdev(errbuf);
        if (dev == NULL) {
            fprintf(stderr, "Couldn't find default device: %s\n", errbuf);
            return 1;
        }
    }

    // Print the device that will be used for capturing packets
    printf("Using device: %s\n", dev);

    // Open the device for packet capture
    handle = pcap_open_live(dev, MAX_PACKET_SIZE, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Couldn't open device %s: %s\n", dev, errbuf);
        return 2;
    }

    // Set a capture filter (optional)
    struct bpf_program fp;   // Compiled filter
    char filter_exp[] = "ip"; // Filter expression
    if (pcap_compile(handle, &fp, filter_exp, 0, PCAP_NETMASK_UNKNOWN) == -1) {
        fprintf(stderr, "Couldn't parse filter %s: %s\n", filter_exp, pcap_geterr(handle));
        return 2;
    }

    // Set the filter
    if (pcap_setfilter(handle, &fp) == -1) {
        fprintf(stderr, "Couldn't install filter %s: %s\n", filter_exp, pcap_geterr(handle));
        return 2;
    }

    // Start packet capturing loop
    printf("Capturing packets... press Ctrl+C to stop.\n");
    pcap_loop(handle, 0, packet_handler, NULL);

    // Cleanup
    pcap_freecode(&fp);
    pcap_close(handle);
    
    return 0;
}